
function PopulatePresets()
{
	while ( AnnotationPreset.length > 0 )
		AnnotationPreset.remove( 0 );

	var presets = moi.geometryDatabase.getAnnotationPresets();

	for ( var i = 0; i < presets.length; ++i )
	{
		var opt = document.createElement( "option" );
		opt.value = i;
		opt.text = presets[i].presetName;
		AnnotationPreset.add( opt );
	}
}

function AnnotationPresetsChanged()
{
	var presets = moi.geometryDatabase.getAnnotationPresets();
	var selected_index = AnnotationPreset.selectedIndex;
	if ( selected_index < 0 )
		selected_index = 0;

	// Check if we have everything the same up to and including selected_index.

	var needs_reset = false;
	for ( var i = 0; i <= selected_index; ++i )
	{
		if ( i > presets.length-1 || AnnotationPreset[i].text != presets[i].presetName )
		{
			needs_reset = true;
			break;
		}
	}

	if ( needs_reset )
	{
		// Previous and new presets do not match up to selected_index, reset the whole list.
		PopulatePresets();
	}
	else
	{
		// Otherwise previous and new preset lists match up to selected_index. Discard
		// everything past selected_index and populate items after selected_index.

		while ( AnnotationPreset.length > selected_index + 1 )
			AnnotationPreset.remove( AnnotationPreset.length - 1 );

		for ( var i = selected_index + 1; i < presets.length; ++i )
		{
			var opt = document.createElement( "option" );
			opt.value = i;
			opt.text = presets[i].presetName;
			AnnotationPreset.add( opt );
		}
	}
}

function GetUrlKey()
{
	var url = document.URL.toLowerCase();
	if ( url.indexOf( 'dimhorizontal.htm' ) != -1 || url.indexOf( 'dimvertical.htm' ) != -1 || url.indexOf( 'dimaligned.htm' ) != -1 )
		url = 'dim_linear';
	else if ( url.indexOf( 'annotationtextdialog.htm' ) != -1 )
		url = 'annotation_text';

	return url;
}

function Initialize()
{
	PopulatePresets();

	var last_preset_index = 0;
	var last_preset_name = '';

	var urlkey = GetUrlKey();

	try {
		var index = moi.command.getOption( urlkey + '_last_used_preset_index' );
		var name = moi.command.getOption( urlkey + '_last_used_preset_name' );
		last_preset_index = index;
		last_preset_name = name;
	}
	catch(e) {}

	if ( last_preset_index < AnnotationPreset.length && AnnotationPreset[last_preset_index].text == last_preset_name )
		AnnotationPreset.selectedIndex = last_preset_index;
}

function Shutdown()
{
	var urlkey = GetUrlKey();

	var index = AnnotationPreset.selectedIndex;
	if ( index >= 0 )
	{
		moi.command.setOption( urlkey + '_last_used_preset_index', index );
		moi.command.setOption( urlkey + '_last_used_preset_name', AnnotationPreset[index].text );
	}
}
